/* Unterprogramme zur Ansteuerung der ADU-Karte*/
#include		<stdio.h>
#include		<mem.h>
#include <graphics.h>
#include <conio.h>
#include <string.h>
#include <io.h>
#include <bios.h>
#include <ctype.h>
#include <dos.h>
#include "key.h"



#define	SPEICHER	0x8a000000l	/*Speicherbereichsanfang*/
#define	STATUS		0x8b000000l	/*Statusbyte*/
#define	ZEILE		2048		/*Lnge der CCD-Zeile*/
#define	BIT0		1		/*Bitposition Startbefehl/fertig*/
#define USCHWELL	0		/*neg.Schwelle = -2V*/
#define	OSCHWELL	0xff            /*pos.Schwelle = nahe Masse*/
#define NP_X		10		/*Nullpunkt Grafik links unten*/
#define NP_Y		150
#define MASKE		0x3f		/*Wertebereich der ADU*/
#define DEZ		0
#define HEX		1
#define gGREEN		1
#define gBLACK		0

static  int     hist[64];
static	char werte[ZEILE];
static  char menue[128]={"\nF1-Zeile F2-Hex F3-Grafik F4-OSZI\nF5-Histogramm F6-Schwellen ESC-Ende"};
static	char fehltext1[]={"\ntime out , Taktversorgung checken !"};
static	char fehltext2[]={"\nPlatine reagiert nicht !"};
static	char fehltext3[]={"  ESC druecken !"};
static  char txt[10];

char	umsetzen(char	*pixel,char u_schwelle,char o_schwelle);
void	histogramm(char *pixel);
void	screen(char *pixel);
void    gw_zeile(int bild_anf_x,int bild_end_x,char []);
void    achs_bez(int x_anf,char typ);
void	oszi(char []);
void	histzeichnen(void);
int	inpnum(long *num,long minnum,long maxnum,int inputmode);
void	clkeybuf(void);
char	adustatus(char o_schwelle);

void main(void)
  {
char fehler;
unsigned char u_schwelle,o_schwelle,puffer1,puffer2;
 long puffer;
 int taste,x,kx,ky;
 int graphdriver = CGA;
 int graphmode = CGAHI;

clrscr();
printf("\n\tADU-Debugger\n\t============\n\nTH Ilmenau / Abe / Version 1.0");
u_schwelle=USCHWELL;	/*Anfangswerte der ADU*/
o_schwelle=OSCHWELL;
taste=0;
x=0;                   	/*Anfangswert fuer graf.Darstellung*/
fehler=adustatus(o_schwelle);if(fehler)
	{
	if(fehler==-1) printf("%s%s",fehltext1,fehltext3);
        else printf("%s%s",fehltext2,fehltext3);
	while((taste=getkey())!=ESC);
	}
while (taste!=ESC)
{
puts(menue);
taste=getkey();
switch(taste) {
	case F1: fehler=umsetzen(werte,u_schwelle,o_schwelle);
		 if(fehler) printf("%s",fehltext1);
		 else printf("\nok");
		 break;
	case F2: screen(werte);break;
	case F3: initgraph(&graphdriver,&graphmode,"\\tc");
		 while(taste!=ESC)
		 {
		 gw_zeile(x,x+600,werte);
		 taste=getkey();
		 switch(taste){
			case LEFTKEY: x-=300;
				if(x<0) x=0;break;
			case RIGHTKEY: x+=300;
				if(x>=ZEILE-600) x=1500;break;
				}
                        }
			closegraph();taste=0;break;
	case F4: initgraph(&graphdriver,&graphmode,"\\tc");
		 taste=0;
		 while(!(taste==ESC))
		 {
		 fehler=umsetzen(werte,u_schwelle,o_schwelle);
		 if(fehler) {
		  printf("%s",fehltext1);while(!(kbhit()));taste=ESC;
		  	}
		 else  {oszi(werte);if(kbhit()) taste=ESC;}
		 }
		 closegraph();taste=getkey();taste=0;break;
	case F5: initgraph(&graphdriver,&graphmode,"\\tc");
		 histogramm(werte);histzeichnen();
		 while(getkey()!=ESC);
		 closegraph();taste=0;break;
	case F6: kx=wherex();ky=wherey();
		 printf("\nuntere Schwelle : %x\nobere Schwelle  : %x",u_schwelle & 0x00ff,o_schwelle & 0x00ff);
	 fehlf6: gotoxy(kx+18,ky+1);
		 inpnum(&puffer,0,0xff,HEX);puffer1=puffer;
		 gotoxy(kx+18,ky+2);
		 inpnum(&puffer,0,0xff,HEX);puffer2=puffer;
                        if(puffer1>=puffer2) goto fehlf6;
		 u_schwelle=puffer1;o_schwelle=puffer2;break;
       }
}
}
	/*UP eine Zeile nach Speicher*/

char	umsetzen(werte,u_schwelle,o_schwelle)
char	*werte;
char	u_schwelle,o_schwelle;
	{
        char far *a;
        char far *b;
	int time_out;

	a =(char *) STATUS;	/*Speicher,Schwellen an Bus */
	*a = 1;
	b =(char *) SPEICHER;
        *b++ = o_schwelle;
	*b-- = u_schwelle;		/*untere,obere Schwelle setzen*/
	*a = 0;				/*nchste Zeile umsetzen*/
	time_out=3000;
	while ((*a & BIT0) && --time_out);      /*Warten auf Fertigmeldung*/
	if(time_out==0)
	 return(-1);
	*a = 1;				/*Ruecknahme des Startbefehls*/
	memcpy(werte,b,ZEILE);
	return(0);                      /* kein Fehler */
	}

/*Status der ADU-Karte ermitteln : 0 ok,-1 Karte hat Timeout
				   -2 Karte reagiert nicht*/

char	adustatus(o_schwelle)
	char o_schwelle;
	{
        char far *a;
        char far *b;
	int time_out;
        char x;

	a =(char *) STATUS;	/*Speicher,Schwellen an Bus */
	*a = 1;
	b =(char *) SPEICHER;
        *b = 0x55;
 	x  = *b;		/*ruecklesen*/
        *b = o_schwelle;       /*aktuelle Schwelle setzen*/
	if(x!=0x55) return(-2);
	*a = 0;			/*nchste Zeile umsetzen*/
	time_out=3000;
	while ((*a & BIT0) && --time_out);      /*Warten auf Fertigmeldung*/
	if(time_out==0)	{*a=1; return(-1);}
	*a=1; return(0);
	}

/*Bilden eines Histogramms ueber eine Zeile*/

void	histogramm(werte)
char	*werte;
{
	int x;

	memset(hist,0,sizeof(int)*64);
	for (x=0;x<ZEILE;x++){
		hist[(werte[x] & MASKE)]+=1;                            }
}

/* Darstellen der Zeile auf Bildschirm */

void	screen(werte)
        char *werte;
{
	char	wert;
	int i=0,e;

	while (i<ZEILE)
	{	printf("%04d :  ",i);
		for(e=0;e<20 && i<=ZEILE ;e++)
		{
                wert=werte[i++] & MASKE;
		printf("%2.2x ",wert);
		}
		putchar('\n');
        }
}


void achs_bez(int x_anf , char typ )
{
int	      x,y,tx,ty;


  line(NP_X,NP_Y,NP_X,NP_Y-128-10);
  for(y=0 ; y<=64 ; y+=10){
      line(NP_X,NP_Y-y*2-10,NP_X+3,NP_Y-y*2-10);
      sprintf(txt,"%2d",y);
      tx = NP_X+5;
      ty = NP_Y-y*2-10;
      outtextxy(tx,ty,txt);
  }
 line(NP_X,NP_Y,NP_X+600,NP_Y);
 setviewport(NP_X,NP_Y+1,639,199,0);clearviewport();setviewport(0,0,639,199,0);
 for(x=0;x<600;x+=100)
	{
	line(NP_X+x+20,NP_Y,NP_X+x+20,NP_Y+3);
	tx = NP_X+x;
	ty = NP_Y+20;
	switch(typ){
		case 0: sprintf(txt,"%4d   ",x_anf+x);break;
		case 1: sprintf(txt,"%4d   ",x_anf+4*x);break;
		    }
	outtextxy(tx,ty,txt);
	}

}


void gw_zeile(int x_anf,int x_end,char werte[])

{
int	      x,bildx;
  bildx=NP_X+20;
  achs_bez(x_anf,0);
  x=x_anf;
  while(x<x_end && x<ZEILE)
  {
	setcolor(gGREEN);
	line(bildx,NP_Y-10,bildx,NP_Y-10-(werte[x] & MASKE)*2);
	setcolor(gBLACK);
	line(bildx,NP_Y-10-(werte[x++] & MASKE)*2,bildx,0);
      bildx += 1;
  }
  if(x>=ZEILE){
	for(;bildx<640;bildx++)
	line(bildx,NP_Y-10,bildx,0);}
    setcolor(gGREEN);
}

void oszi(char werte[])

 {
 int x,bildx,mittel;

	bildx=NP_X+20;
	achs_bez(0,1);
	x=0;
	while(x<ZEILE){
		mittel=((werte[x++])+(werte[x++])+(werte[x++])+(werte[x++]))/4;
		setcolor(gGREEN);
                line(bildx,NP_Y-10,bildx,NP_Y-10-(mittel & MASKE )*2);
                setcolor(gBLACK);
		line(bildx,NP_Y-10-(mittel & MASKE )*2,bildx,0);
		bildx+=1;
			}

	setcolor(gGREEN);
 }

void histzeichnen(void)

{       int x,bildx;

	achs_bez(0,1);bildx=NP_X+20;
	for(x=0;x<64;x++){
		setcolor(gGREEN);
		line(bildx,NP_Y-10-2*x,bildx+(hist[x]/4),NP_Y-10-2*x);
		setcolor(gBLACK);
		line(bildx+(hist[x]/4),NP_Y-10-2*x,639,NP_Y-10-2*x);
			}
	setcolor(gGREEN);
}

/*****************************************************************************/

void clkeybuf(void)

{
 _AH=0x0c;
 _AL=0;
 geninterrupt(0x21);
} /* end clkeybuf */

/*****************************************************************************/

int	inpnum(num,minnum,maxnum,inputmode)
long	*num;
long    minnum;
long	maxnum;
int	inputmode;

{
 int x,y;      /* Cursorkoordinaten */
 long value;   /* Eingabewert */
 char str1[256]={""};
 char str2[256]={""};
 char dez[]="-0123456789";
 char hex[]="0123456789abcdefABCDEF";
 int len;
 char *strp;

 x=wherex();
 y=wherey();
 for(;;)
  {gets(str1);
   gotoxy(x,y);
   clreol();
   clkeybuf();
   if(strlen(str1))
    {if((strp=strchr(str1,' '))!=NULL)
      *strp='\0';
     switch(inputmode)
      {case HEX : len=strspn(str1,hex);
		  strncpy(str2,str1,len);
		  str2[len]='\0';
                  break;
       case DEZ : len=strspn(str1,dez);
		  strncpy(str2,str1,len);
		  str2[len]='\0';
      }
     if(strlen(str2))
      {int i=0;

       if(str2[0]!='-')
        {while(isxdigit(str2[++i]));
	 if(str2[i]=='-')
	  continue;
	}
       else {while(str2[++i]=='0');
	     if(str2[i]=='\0')
	      continue;
	     i--;
             while(isxdigit(str2[++i]));
             if(str2[i]=='-')
	      continue;
	    }
       if(inputmode==HEX)
        {if(!sscanf(str2,"%lx",&value))
          sscanf(str2,"%lX",&value);
	}
       else sscanf(str2,"%ld",&value);
       if(value>=minnum&&value<=maxnum)
        {*num=value;
	 gotoxy(x,y);
         if(inputmode==DEZ)
          printf("%ld",value);
	 else printf("%lX",value);
         return(CR);
        }
      }
    }
   else return(ESC);
  } /* end for... */
} /* end inpnum */
!Aa 